#include "fenetrecontrole.h"
#include "ui_fenetrecontrole.h"

//Ces données seront fournies dans un fichier de configuration
#define TEMPERATUREMIN 10
#define TEMPERATUREMAX 40
#define HUMIDITEMIN 0
#define HUMIDITEMAX 100

FenetreControle::FenetreControle(QWidget *parent) : QMainWindow(parent), ui(new Ui::FenetreControle)
{
    ui->setupUi(this);

    //On set les valeurs minimum et maximum de la température et de l'humidité dans les différents widgets
    ui->temperatureMinimum->setText(QString::number(TEMPERATUREMIN));
    ui->temperatureMaximum->setText(QString::number(TEMPERATUREMAX));
    ui->humiditeMinimum->setText(QString::number(HUMIDITEMIN));
    ui->humiditeMaximum->setText(QString::number(HUMIDITEMAX));
    ui->sliderTemperature->setRange(TEMPERATUREMIN, TEMPERATUREMAX);
    ui->progressBarTemperature->setRange(TEMPERATUREMIN, TEMPERATUREMAX);
    ui->sliderHumidite->setRange(HUMIDITEMIN, HUMIDITEMAX);
    ui->progressBarHumidite->setRange(HUMIDITEMIN, HUMIDITEMAX);

    checkerBoutonsContextuels();
}

FenetreControle::~FenetreControle()
{
    delete ui;
}

//Signaux

//Slots

//Autoconnects
//Les boutons sensitifs
void FenetreControle::on_boutonArrosage_clicked()
{
    if(ui->rougeArrosage->isEnabled())
    {
	ui->boutonArrosage->setText("Arrêter");
        ui->vertArrosage->setEnabled(true);
        ui->rougeArrosage->setEnabled(false);
	ui->actionLancerArrosage->setText("Lancer l'arrosage");
    }
    else
    {
	ui->boutonArrosage->setText("Démarrer");
        ui->rougeArrosage->setEnabled(true);
        ui->vertArrosage->setEnabled(false);
	ui->actionLancerArrosage->setText("Arrêter l'arrosage");
    }
}
void FenetreControle::on_boutonFenetreNord_clicked()
{
    if(ui->rougeFenetreNord->isEnabled())
    {
	ui->boutonFenetreNord->setText("Fermer");
	ui->vertFenetreNord->setEnabled(true);
	ui->rougeFenetreNord->setEnabled(false);
    }
    else
    {
	ui->boutonFenetreNord->setText("Ouvrir");
	ui->rougeFenetreNord->setEnabled(true);
	ui->vertFenetreNord->setEnabled(false);
    }
}
void FenetreControle::on_boutonFenetreSud_clicked()
{
    if(ui->rougeFenetreSud->isEnabled())
    {
	ui->boutonFenetreSud->setText("Fermer");
	ui->vertFenetreSud->setEnabled(true);
	ui->rougeFenetreSud->setEnabled(false);
    }
    else
    {
	ui->boutonFenetreSud->setText("Ouvrir");
	ui->rougeFenetreSud->setEnabled(true);
	ui->vertFenetreSud->setEnabled(false);
    }
}
void FenetreControle::on_boutonPorte_clicked()
{
    if(ui->rougePorte->isEnabled())
    {
	ui->boutonPorte->setText("Fermer");
	ui->vertPorte->setEnabled(true);
	ui->rougePorte->setEnabled(false);
    }
    else
    {
	ui->boutonPorte->setText("Ouvrir");
	ui->rougePorte->setEnabled(true);
	ui->vertPorte->setEnabled(false);
    }
}
void FenetreControle::on_actionLancerArrosage_triggered()
{
    on_boutonArrosage_clicked();
}


//Autres fonctions
void FenetreControle::checkerBoutonsContextuels()
{
    if(ui->rougeArrosage->isEnabled())
    {
	ui->boutonArrosage->setText("Démarrer");
        ui->vertArrosage->setEnabled(false);
    }
    else
    {
	ui->boutonArrosage->setText("Arrêter");
        ui->rougeArrosage->setEnabled(false);
    }
}
