#include <stdio.h>
#include <stdlib.h>


int formeLigne(int ligne, int colonne, char* tab[]);

int verifier(char* tableau[]);


//Si jamais le joueur n'est pas defini, on decide que c'est le premier joueur qui joue en premier, sinon, on inverse le joueur qui doit jouer
int changerJoueur(char* stateJoueur){
    if(*stateJoueur == 1 || *stateJoueur == -1){
        *stateJoueur *= -1;
        return 1;
    } else {
        *stateJoueur = 1;
        return 1;
    }
    return 0;
}

//on affiche le tableau en le parcourant
void afficherTableau(char* tab[]){
    //caractere a ecrire
    char toPrint;
    int i, j;
    char lettre = 65;
    printf("  ------------------------------\n");
    for(i = 0;i<6; i++){
        printf("%c |", lettre);
        lettre++;
        for(j = 0; j<7; j++){
            if(tab[i][j] == 1){
                toPrint = 'O';
            } else if(tab[i][j] == -1){
                toPrint = 'X';
            } else {
                toPrint = ' ';
            }
            printf(" %c |", toPrint);
        }
        printf("\n  ------------------------------\n");
    }

    printf("    1   2   3   4   5   6   7\n");
    printf("\n");
}

int main()
{
    char* tab[6];
    int i, j, continuer = 0, fini = 0;
    char stateJoueur;
    int colonne = 0;

    //boucle generale du jeu
    do{
        //initialisation du tableau
        stateJoueur = 0;
        for(i=0;i<6;i++){
            tab[i] = (char*) malloc(sizeof(char*));
            for(j=0;j<7;j++){
                tab[i][j] = 0;
            }
        }

        //boucle de la partie
        do{

            //on efface la console pour être plus propre
            system("clear");

            //on commence par changer le joueur qui commence
            if(!changerJoueur(&stateJoueur)){
                printf("Erreur !");
                return 1;
            }

            //si c'est bon, on passe a la suite

            //on dit de quel joueur c'est le tour
            if(stateJoueur == 1){
                printf("Joueur 1 -\n\n");
            } else if (stateJoueur == -1){
                printf("Joueur 2 -\n\n");
            }

            //on affiche le tableau pour que le joueur sache où jouer
            afficherTableau(tab);


            //on demande au joueur ou jouer
            do{
                printf("\nNumero de la colonne ou jouer (1 a 7) : ");
                scanf("%d", &colonne);
            } while(colonne < 1 || colonne > 7 || tab[0][colonne-1]);


            //la colonne etant comprise entre 1 et 7 pour etre plus intuitive a utiliser, il faut la reconvertir pour l'utiliser dans le tableau
            colonne--;

            //on determine la ligne dans laquelle ajouter le pion et on l'y ajoute
            i = 0;
            while(!tab[i+1][colonne] && i<4){
                i++;
            }

            //moche mais seule façon d'eviter les SEGMENTATION_FAULT
            if(i == 4 && !tab[5][colonne]){
                tab[5][colonne] = stateJoueur;
            } else {
                tab[i][colonne] = stateJoueur;
            }

            //verification de la grille, si l'un des joueurs gagne, on détermine lequel et on s'arrete
            //sinon, on recommence la boucle de jeu pour que l'autre joueur ajoute sa propre valeur
            fini = verifier(tab);
        } while(fini == 0);

        //une fois la partie finie, on affiche le joueur ayant gagne et la grille
        system("clear");
        if(fini == 1){
            printf("Le Joueur 1 a gagne ! Bravo !\n");
        } else if(fini == -1){
            printf("Le Joueur 2 a gagne ! Bravo !\n");
        } else if(fini == 2){
            printf("Match nul !");
        }
        printf("\n");
        afficherTableau(tab);

        for(i = 0; i<6; i++){
            free(tab[i]);
        }
        printf("Voulez-vous recommencer ? Oui : 1, Non : 0\n");
        scanf("%d", &continuer);
    } while(continuer);
    return 0;
}


int verifier(char* tab[]){

    int ligne = 0, colonne = 0, estLigne = 0;

    //Boucle qui parcourt le tableau tant qu'on en sort pas
    while((colonne < 8 && ligne < 6)){
        if(tab[ligne][colonne]){
            estLigne = formeLigne(ligne, colonne, tab);
            if(estLigne){
                return estLigne;
            }
        }
        colonne++;
        ligne += (colonne - colonne%8) / 8;
        colonne = colonne%8;
    }
    return 0;
}


int formeLigne(int ligne, int colonne, char* tab[]){
    int matchNul = 1;
    //verification en ligne
    //si la colonne est supérieure a 4, on ne peut pas acceder au tableau car les cases n'existent pas, donc la ligne est impossible a faire
    //sinon, l'acces est possible
    if(colonne < 4){
        char* tabTmp;
        tabTmp = tab[ligne];
        if(tabTmp[colonne] == tabTmp[colonne+1] && tabTmp[colonne] == tabTmp[colonne+2] && tabTmp[colonne] == tabTmp[colonne+3]){
            return tabTmp[colonne];
        }
    }

    //verification verticale
    if(ligne < 3){
        if(tab[ligne][colonne] == tab[ligne+1][colonne] && tab[ligne][colonne] == tab[ligne+2][colonne] && tab[ligne][colonne] == tab[ligne+3][colonne]){
            return tab[ligne][colonne];
        }
    }

    //verification en diagonale vers le haut a droite
    //comme la diagonale est systematiquement lue depuis le pion le plus a gauche
    //le premier point est celui le plus en bas
    if(ligne > 2 && colonne <4){
        if(tab[ligne][colonne] == tab[ligne-1][colonne+1] && tab[ligne][colonne] == tab[ligne-2][colonne+2] && tab[ligne][colonne] == tab[ligne-3][colonne+3]){
            return tab[ligne][colonne];
        }
    }

    //meme chose vers le bas a droite
    if(ligne < 3 && colonne <4){
        if(tab[ligne][colonne] == tab[ligne+1][colonne+1] && tab[ligne][colonne] == tab[ligne+2][colonne+2] && tab[ligne][colonne] == tab[ligne+3][colonne+3]){
            return tab[ligne][colonne];
        }
    }

    for(ligne = 0; ligne < 6; ligne++){
        for(colonne = 0; colonne < 7; colonne++){
            matchNul *= tab[ligne][colonne];
        }
    }
    if(matchNul){
        return 2;
    }
    return 0;
}
