#include <stdio.h>
#include <stdlib.h>
#include <math.h>

//Préparation de notre structure Point
typedef struct Point
{
    int x;
    int y;
    long couleur;
}Point;

void trierTableau(Point *array, int critere, int arrayLength);


int main()
{
    printf("\n=*=*=*=*=*=*=*=*=*=*= Triage =*=*=*=*=*=*=*=*=*=*=\n");

    //Initialisation des variables
    Point array[10]; //Le tableau à trier
    int i = 0; //Itérateur
    int arrayLength = sizeof(array) / sizeof(array[0]); //On obtient la longueur du tableau
    printf("Longueur du tableau : %d\n", arrayLength);
    int choixUtilisateur = 0;

    srand(time(NULL)); //Introduction de la graine pour les nombres aléatoires

    //Initialisation du tableau
    printf("\n\n ===== Tableau non trié =====\n");
    for(i = 0; i < 10; i ++)
    {
        array[i].x = rand() % 100; //Un chiffre aléatoire entre 0 et 100
        array[i].y = rand() % 100; //Un chiffre aléatoire entre 0 et 100
        array[i].couleur = rand() % 65530; //Un chiffre aléatoire entre 0 et 100

        printf("Valeur de x : %d\n", array[i].x);
        printf("Valeur de y : %d\n", array[i].y);
        printf("Valeur de couleur : %ld\n\n", array[i].couleur);
    }

    //On demande à l'utilisateur le critère qu'il veut
    do
    {
        printf("Par quel critère souhaitez vous trier le tableau ? 1 : X, 2 : Y, 3 : Couleur\n");
        scanf("%d", &choixUtilisateur);
    } while(choixUtilisateur < 1 || choixUtilisateur > 3);

    trierTableau(array, choixUtilisateur, arrayLength);

    //Sortie du tableau trié
    /*printf("\n\n ====== Tableau trié =====\n");
    for(i = 0; i < 10; i ++)
    {
        printf("Valeur de x : %d\n", array[i].x);
        printf("Valeur de y : %d\n", array[i].y);
        printf("Valeur de couleur : %ld\n\n", array[i].couleur);
    }*/

    return 0;
}

void trierTableau(Point *array, int critere, int arrayLength)
{//Fonction de tri du tableau
    printf("choix utilisateur : %d", critere);
    char isSorted = 0;
    int i = 0; //Itérateur

    //Tri du tableau par bubble sort selon le choix de l'utilisateur
    switch(critere)
    {
        //TRI PAR X
        case 1:
            do
            {
                isSorted = 1;
                printf("Case 1");
                for(i = 0; i < arrayLength; i++)
                {
                    if(array[i].x > array[i+1].x)
                    {
                        //Inversion des deux cases
                        int plusGrand = array[i].x;
                        array[i].x = array[i+1].x;
                        array[i+1].x = plusGrand;

                        isSorted = 0; //Si il a du inverser deux cases, le tableau n'est pas trié
                    }
                }
            }
            while(isSorted == 0);//On continue notre algorithme tant que le tableau n'est pas trié
            break;

        //TRI PAR Y
        case 2:
            do
            {
                isSorted = 1;
                printf("Case 2");
                for(i = 0; i < arrayLength; i++)
                {
                    if(array[i].y > array[i+1].y)
                    {
                        //Inversion des deux cases
                        int plusGrand = array[i].y;
                        array[i].y = array[i+1].y;
                        array[i+1].y = plusGrand;

                        isSorted = 0; //Si il a du inverser deux cases, le tableau n'est pas trié
                    }
                }
            }
            while(isSorted == 0);//On continue notre algorithme tant que le tableau n'est pas trié
            break;

        //TRI PAR COULEUR
        case 3:
            do
            {
                isSorted = 1;
                printf("Case 3");
                for(i = 0; i < arrayLength; i++)
                {
                    if(array[i].couleur > array[i+1].couleur)
                    {
                        //Inversion des deux cases
                        int plusGrand = array[i].couleur;
                        array[i].couleur = array[i+1].couleur;
                        array[i+1].couleur = plusGrand;

                        isSorted = 0; //Si il a du inverser deux cases, le tableau n'est pas trié
                    }
                }
            }
            while(isSorted == 0);//On continue notre algorithme tant que le tableau n'est pas trié
            break;

        default:
            printf("Erreur");
            break;
    }

    printf("\n\n ====== Tableau trié =====\n");
    for(i = 0; i < 10; i ++)
    {
        printf("Valeur de x : %d\n", array[i].x);
        printf("Valeur de y : %d\n", array[i].y);
        printf("Valeur de couleur : %ld\n\n", array[i].couleur);
    }

}
