#include <stdio.h>
#include <stdlib.h>
#define COTETABLEAU 3
//Le prototype de nos fonctions
void afficherTableau(char **tableauAAfficher);
int verifierVictoire(int **tableauAVerifier);

//const int COTETABLEAU = 3; //Le coté du carré de jeu (par défaut, 3 cases)

int main()
{
    //On efface la console
    system("clear");

    char **tableau_puissance; //Le tableau à afficher, où l'on place les croix et les ronds
    int **tableau_poids; //Le tableau que l'on utilise pour calculer la victoire (on y place le poids de chaque signe)
    int i, j, k; //Nos itérateurs
    int x, y; //Les variables utilisées par le joueur pour placer son jeu
    char termine = 0; //Passe à 1 si le X a gagné, à 2 si le O a gagné

    //Initialisation du tableau de jeu
    tableau_puissance = (char**)malloc(sizeof(char*) * COTETABLEAU);
    for(i = 0; i < COTETABLEAU; i++)
    {
        tableau_puissance[i] = (char*)malloc(sizeof(char) * COTETABLEAU);
    }
    for(i = 0; i < COTETABLEAU; i++)
    {
        for(j = 0; j < COTETABLEAU; j ++)
        {
            tableau_puissance[i][j] = ' ';
        }
    }

    //Initialisation du tableau des poids
    tableau_poids = (int**)malloc(sizeof(int*) * COTETABLEAU);
    for(i = 0; i < COTETABLEAU; i++)
    {
        tableau_poids[i] = (int*)malloc(sizeof(int) * COTETABLEAU);
    }
    for(i = 0; i < COTETABLEAU; i++)
    {
        for(j = 0; j < COTETABLEAU; j ++)
        {
            tableau_poids[i][j] = 0;
        }
    }

    //On affiche le tableau de jeu
    afficherTableau(tableau_puissance);

    //LA BOUCLE DE JEU, elle ne s'arrête que lorsque quelqu'un a gagné
    while(termine != 1 && termine != 2 && termine != 3)
    {
        //TOUR DU JOUEUR 1
        printf("\nLe joueur 1 joue :\n");
        printf("Coordonnées (entre 0 et 2) :\n");

        do
        {
            printf("x : ");
            scanf("%d", &x);
        } while(x < 0 || x > COTETABLEAU - 1);

        do
        {
            printf("y : ");
            scanf("%d", &y);
        } while(y < 0 || y > COTETABLEAU - 1);

        printf("\nLe joueur 1 joue en (%d; %d).\n", x, y);

        //On vérifie que le scanf est correct (qu'il rentre dans les limites du tableau)
        if(x >= 0 && x < COTETABLEAU && y >= 0 && y < COTETABLEAU)
        {//On place le coup du joueur
            if(tableau_puissance[y][x] == ' ')
            {
                tableau_puissance[y][x] = 'X'; //On place le symbole dans le tableau de jeu
                tableau_poids[y][x] = 1; //On place le poids dans le tableau des poids
            }
        }
        //FIN DU TOUR DU JOUEUR 1

        //On efface la console
        system("clear");
        //On affiche le tableau
        afficherTableau(tableau_puissance);
        //On vérifie la victoire
        termine = verifierVictoire(tableau_poids);

        //TOUR DU JOUEUR 2
        if(termine != 1 && termine != 2 && termine != 3)
        {
            printf("\nLe joueur 2 joue :\n");
            printf("Coordonnées (entre 0 et 2) :\n");

            do
            {
                printf("x : ");
                scanf("%d", &x);
            } while(x < 0 || x > COTETABLEAU - 1);

            do
            {
                printf("y : ");
                scanf("%d", &y);
            } while(y < 0 || y > COTETABLEAU - 1);
            printf("\nLe joueur 2 joue en (%d; %d).\n", x, y);

            //On vérifie que le scanf est correct (qu'il rentre dans les limites du tableau)
            if(x >= 0 && x < COTETABLEAU && y >= 0 && y < COTETABLEAU)
            {//On place le coup du joueur
                if(tableau_puissance[y][x] == ' ')
                {
                    tableau_puissance[y][x] = 'O'; //On place le symbole dans le tableau de jeu
                    tableau_poids[y][x] = -1; //On place le poids dans le tableau des poids
                }
            }
        }
        //FIN DU TOUR DU JOUEUR 2

        //On efface la console
        system("clear");
        //On affiche le tableau
        afficherTableau(tableau_puissance);
        //On vérifie la victoire
        termine = verifierVictoire(tableau_poids);
    }


    //La petite phrase de fin
    if(termine == 1)
    {
        printf("\n=*=*=*=*=*= Le joueur 1 a gagné ! =*=*=*=*=*=\n");
    }
    else if(termine == 2)
    {
        printf("\n=*=*=*=*=*= Le joueur 2 a gagné ! =*=*=*=*=*=\n");
    }
    else if(termine == 3)
    {
        printf("\n=*=*=*=*=*= C'est un match nul... =*=*=*=*=*=\n");
    }

    return 0;
}

void afficherTableau(char **tableauAAfficher)
{
    printf("\n=*=*=*=*=*=*=*=*=*=*= Le morpion =*=*=*=*=*=*=*=*=*=*=\n");

    int i, j;

    //Affichage du tableau dans une double boucle (i : les lignes, j : les colonnes)
    for(i = 0; i < COTETABLEAU * 1.5; i++)
    {
        printf("_");
    }
    printf("\n");
    for(i = 0; i < COTETABLEAU; i++)
    {
        printf("|");
        for(j = 0; j < COTETABLEAU; j ++)
        {
            printf("%c", tableauAAfficher[i][j]);
        }
        printf("|\n");
    }
    for(i = 0; i < COTETABLEAU * 1.5; i++)
    {
        printf("-");
    }
    printf("\n");
}

int verifierVictoire(int **tableauAVerifier)
{
    int i, j; //Les itérateurs
    int sommeLigne = 0; //La somme des poids sur une ligne
    int sommeColonne = 0; //La somme des poids sur une colonne
    int sommeDiagonale = 0; //La somme des poids sur une diagonale
    int caseVideRestante = COTETABLEAU * COTETABLEAU; //Booleen, s'il ne reste aucune case vide, il reste à 0

    for(i = 0; i < COTETABLEAU; i++)
    {
        for(j = 0; j < COTETABLEAU; j ++)
        {
            //On additionne les poids sur chaque ligne et chaque colonne
            sommeLigne += tableauAVerifier[i][j];
            sommeColonne += tableauAVerifier[j][i];

            //Vérification de la victoire en ligne
            if(sommeLigne >= COTETABLEAU)
            {
                return 1;
            }
            else if(sommeLigne <= -COTETABLEAU)
            {
                return 2;
            }
            //Vérification de la victoire en colonne
            if(sommeColonne >= COTETABLEAU)
            {
                return 1;
            }
            else if(sommeColonne <= -COTETABLEAU)
            {
                return 2;
            }
        }
        sommeLigne = 0;
        sommeColonne = 0;
    }

    //Vérification de la victoire pour la première diagonale (de haut-gauche à bas-droite)
    for(i = 0; i < COTETABLEAU; i++)
    {
        sommeDiagonale += tableauAVerifier[i][i];

        if(sommeDiagonale >= COTETABLEAU)
        {
            return 1;
        }
        else if(sommeDiagonale <= -COTETABLEAU)
        {
            return 2;
        }
    }
    sommeDiagonale = 0;

    //Vérification de la victoire pour la seconde diagonale (de bas-gauche à haut-droit)
    for(i = 0; i < COTETABLEAU; i++)
    {
        sommeDiagonale += tableauAVerifier[COTETABLEAU - 1 - i][i];

        if(sommeDiagonale >= COTETABLEAU)
        {
            return 1;
        }
        else if(sommeDiagonale <= -COTETABLEAU)
        {
            return 2;
        }
    }
    sommeDiagonale = 0;

    //Vérification du match nul
    for(i = 0; i < COTETABLEAU; i++)
    {
        for(j = 0; j < COTETABLEAU; j ++)
        {
            if(tableauAVerifier[i][j] != 0)
            {
                caseVideRestante -= 1;
            }
        }
    }
    if(caseVideRestante <= 0)
    {
        return 3;
    }
    else
    {
        caseVideRestante = 0;
    }

    //Si personne n'a gagné, on ne change rien
    return 0;
}
