#include "widget.h"
#include "ui_widget.h"
#include <string.h>

Widget::Widget(QWidget *parent)
    : QWidget(parent), ui(new Ui::Widget)
{
    ui->setupUi(this);
    connect(ui->pushButton, SIGNAL(clicked()), this, SLOT(launchCreate()));
    connect(ui->ecrireButton, SIGNAL(clicked()), this, SLOT(write()));
    connect(ui->read_button, SIGNAL(clicked()), this, SLOT(read()));
}

Widget::~Widget()
{
    delete ui;
    memory->detach();
}

QString Widget::launchCreate(){
    QString create = QInputDialog::getText(this,"Adresse a partager", "Entrez l'adresse a partager");
    memory = new QSharedMemory();
    memory->setKey(create);
    if(memory->create(QString("0:blablablablabla").size(),QSharedMemory::ReadWrite)){
        ui->label->setText(ui->label->text() + "\n" +"Fa marfe " + memory->key());
        ui->pushButton->setDisabled(true);
    } else {
        ui->label->setText(memory->errorString());
        memory->setKey(create);
        if(memory->attach(QSharedMemory::ReadWrite)){
            ui->label->setText(ui->label->text() + "\n" + "Connecte");
            ui->pushButton->setDisabled(true);
        } else {
            ui->label->setText(ui->label->text() + "\n" + memory->errorString());
        }
    }
    return create;
}


void Widget::write(){
    bool ok = false;
    QString text = QInputDialog::getText(this, "entrez un texte", "Entrez un texte", QLineEdit::Normal, "", &ok);
    if(ok){
        memory->lock();
        QByteArray ba = text.toAscii();
        char *to = (char*)memory->data();
        const char *from = ba.data();
        memcpy(to, from, ba.size());
        ui->label->setText(ui->label->text() + "\najouté la valeur : " + (char*)memory->data());
        memory->unlock();
    }

}

void Widget::read(){
    QString text;

    memory->lock();
    text = (char*) memory->data();
    ui->label->setText(ui->label->text() + "\ntexte ajoute : " + (QString)text);
    memory->unlock();
}
