#include </usr/include/stdio.h>
#include </usr/include/stdlib.h>
#include </usr/include/pthread.h>
#include </usr/include/time.h>
#include </usr/include/unistd.h>
#include <QtCore/QCoreApplication>
#include <QDebug>
#include "recupererValeurs.c"
#include "sharedmem.h"

#define TEMPS_ATTENDRE 2

pthread_t threadHumi;
pthread_t threadTemp;

void* testHumi(void* Humi)
{
    SharedMem memWrite("write", QString("123456789ABCDE").size());
    SharedMem memRead("read", QString("123456789").size());

    sleep (2);
    int test = 1;
    int dHumi=(int)Humi;
    while (test == 1)
    {
        dHumi = recupHumi(&memRead);
        if ( dHumi > 40 || dHumi < 30)
        {
	    changeHumi(&memWrite,dHumi);		    // Si le resultat du capteur est inferieur a 30 ou superieur a 40, alors, un processus se declenche pour
            test = 1;                                      // faire revenir au degré d'humidité a 35.
            sleep (TEMPS_ATTENDRE);
            dHumi = recupHumi(&memRead);
            if (dHumi > 40 || dHumi < 30)
            {
                printf("ATTENTION! LE PROCESSUS DE REGULATION DE L'HUMIDITE A ECHOUE!\n");
            }
            printf("Le degré d'humidité est de %d\n", dHumi);
        }
        else
        {
            printf("Le degré d'humidité est de %d\n", dHumi);
            test = 1;
            sleep (5);
        }

    }
    return (void*)dHumi;
}

void* testTemp(void* tTemp)
{
    SharedMem memWrite("write", QString("123456789ABCDE").size());
    SharedMem memRead("read", QString("123456789").size());
    int test = 1;
    int temp=(int)tTemp;
    while (test == 1)
    {
        temp = recupTemp(&memRead);
        if ( temp > 35 || temp < 30)
        {
            changeTemp(&memWrite, temp);
            test = 1;                  // Si le resultat du thermometre est inferieur a 30 ou superieur a 35, alors, un processus se declencherai pour
            sleep (TEMPS_ATTENDRE);
            temp = recupTemp(&memRead);
            if (temp > 35 || temp < 30)   // Verification du processus de regulation
            {
                printf("ATTENTION! LE PROCESSUS DE REGULATION DE LA TEMPERATURE A ECHOUE!\n");
            }
            printf("La temperature est de %d\n", temp);
        }                              // faire revenir la temperature a 32.
        else
        {
            printf("La temperature est de %d\n", temp);
            test = 1;
            sleep (5);
        }

    }
    return (void*)temp;
}

int main(int argc, char *argv[])
{

    QCoreApplication a(argc, argv);
    int Humi;
    int tTemp;
    pthread_create(&threadHumi, NULL, testHumi, (void*)Humi);     // Creation du thread Humidité
    pthread_create(&threadTemp, NULL, testTemp, (void*)tTemp);    // Creation du thread Temperature


    return a.exec();
}
