#include "sharedmem.h"

SharedMem::SharedMem(QString key, int size)
{
    //on cree et/ou attache memory a la memoire partagee
    memory = new QSharedMemory(key, this);
    if(!memory->create(size)){
        memory->attach(QSharedMemory::ReadWrite);
    }
}

SharedMem::~SharedMem(){
    //~QObject();

    //on detache la memoire, si c'est la derniere instance a utiliser
    //cette zone memoire, alors elle est detruite
    memory->detach();
}

QString SharedMem::read(bool erase){
    //lecture de la memoire partagée
    char* text;
    memory->lock();
    text = (char*) memory->data();
    memory->unlock();

    if(erase){
        //vidage de la zone de memoire partagée en remplacant le texte par une chaine vide
        QString empty;
        for(unsigned int i = 0; i < QString(text).size(); i++){
            empty += (QString) " ";
        }
        write(empty, false);
    }
    return (QString)text;
}

int SharedMem::write(QString msg, bool ignore){
    //on transforme le message en une suite d'octets codés en ASCII
    QByteArray ba = msg.toAscii();
    //on empêche les accès à la mémoire pour éviter les conflits
    memory->lock();

    //on récupère le pointeur de la zone mémoire partagée
    //et on le convertit en QString
    char *to = (char*)memory->data();
    QString memoryString = (QString) *to;

    if(ignore){
        //si la zone de mémoire est vide
        if(memoryString.at(0) == QString(" ").at(0) && memory->size()){
            const char *from = ba.data();
            //on met le message dans la zone mémoire partagée
            memcpy(to, from, ba.size());
        }
    } else {
        const char *from = ba.data();
        //on met le message dans la zone mémoire partagée
        memcpy(to, from, ba.size());
    }
    //on dévérouille la mémoire pour qu'un autre utilisateur puisse travailler dessus
    memory->unlock();
    return 1;
}


/*
void SharedMem::clear(){
    memclr(memory->data(), memory->size());
}*/
