#include "/usr/include/stdio.h"
#include "fenetrecontrole.h"
#include "ui_fenetrecontrole.h"

//Ces données seront fournies dans un fichier de configuration
#define TEMPERATUREMIN 10
#define TEMPERATUREMAX 40
#define HUMIDITEMIN 0
#define HUMIDITEMAX 100

FenetreControle::FenetreControle(QWidget *parent) : QMainWindow(parent), ui(new Ui::FenetreControle)
{
    ui->setupUi(this);

    //On set les valeurs minimum et maximum de la température et de l'humidité dans les différents widgets
    ui->temperatureMinimum->setText(QString::number(TEMPERATUREMIN));
    ui->temperatureMaximum->setText(QString::number(TEMPERATUREMAX));
    ui->humiditeMinimum->setText(QString::number(HUMIDITEMIN));
    ui->humiditeMaximum->setText(QString::number(HUMIDITEMAX));
    ui->sliderTemperature->setRange(TEMPERATUREMIN, TEMPERATUREMAX);
    ui->progressBarTemperature->setRange(TEMPERATUREMIN, TEMPERATUREMAX);
    ui->sliderHumidite->setRange(HUMIDITEMIN, HUMIDITEMAX);
    ui->progressBarHumidite->setRange(HUMIDITEMIN, HUMIDITEMAX);
    ui->lcdHumiditeDemandee->display(ui->sliderHumidite->value());
    ui->lcdTemperatureDemandee->display(ui->sliderTemperature->value());

    //On vérifie que les boutons ont bien les bons labels
    checkerBoutonsContextuels();

    //On initialise les poids
    //Ces variables définissent combien on doit enlever ou ajouter au cours du temps à l'humidité et à la température
    m_poidsHumidite = 0;
    m_poidsTemperature = 0;

    //On connecte les timers
    m_timerHumidite = new QTimer(this);
    m_timerTemperature = new QTimer(this);
    m_timerPoids = new QTimer(this);
    connect(m_timerHumidite, SIGNAL(timeout()), this, SLOT(gererProgressHumidite()));
    connect(m_timerTemperature, SIGNAL(timeout()), this, SLOT(gererProgressTemperature()));
    connect(m_timerPoids, SIGNAL(timeout()), this, SLOT(gererPoids()));

    //On initialise la mémoire partagée dans laquelle on va lire
    memoirePartageeEcriture = new SharedMem("write", QString("ninjaninjaninja").size());
    //On écrase ce qui était là avant
    memoirePartageeEcriture->write("ninjaninjaninja");

    //On initialise la mémoire partagée dans laquelle on va écrire
    memoirePartageeLecture = new SharedMem("read", QString("ninjaninjaninja").size());
    //On vide la mémoire en mettant des espaces à la place
    memoirePartageeLecture->write("        ", false);
    //On donne tout de suite la température par défaut
    memoirePartageeLecture->write("t" + QString::number(ui->progressBarHumidite->value()) + "|h" + QString::number(ui->progressBarHumidite->value()), false);

    //On vérifie s'il y a des instructions à récupérer
    checkerMemoirePartagee();
    //Le timer qui check la mémoire partagée toutes les secondes
    m_timerMemoirePartagee = new QTimer(this);
    connect(m_timerMemoirePartagee, SIGNAL(timeout()), this, SLOT(checkerMemoirePartagee()));
    m_timerMemoirePartagee->start(1000);
}

FenetreControle::~FenetreControle()
{
    //On vide la mémoire partagée
    memoirePartageeEcriture->write("                ");
    memoirePartageeLecture->write("        ");
    delete ui;
}


//CONTROLE DES FENETRES, ETC
void FenetreControle::ouvrirFenetreNord()
{
    //Quand la fenêtre est ouverte, l'humidité et la température diminuent
    if(ui->rougeFenetreNord->isEnabled())
    {//On diminue les poids seulement si la fenêtre était fermée avant
	m_poidsHumidite -= 1;
	m_poidsTemperature -= 1;
    }

    //On ouvre la fenêtre nord
    ui->boutonFenetreNord->setText("Fermer");
    ui->vertFenetreNord->setEnabled(true);
    ui->rougeFenetreNord->setEnabled(false);

    //On lance le timer qui gère les poids
    if(!(m_timerPoids->isActive()))
    {
	m_timerPoids->start(2500);
    }
}
void FenetreControle::fermerFenetreNord()
{
    if(ui->vertFenetreNord->isEnabled())
    {//On augmente les poids seulement si la fenêtre était ouverte avant
	m_poidsHumidite += 1;
	m_poidsTemperature += 1;
    }

    //On ferme la fenêtre nord
    ui->boutonFenetreNord->setText("Ouvrir");
    ui->rougeFenetreNord->setEnabled(true);
    ui->vertFenetreNord->setEnabled(false);

    //On lance le timer qui gère les poids
    if(!(m_timerPoids->isActive()))
    {
	m_timerPoids->start(2500);
    }
}
void FenetreControle::ouvrirFenetreSud()
{
    if(ui->rougeFenetreSud->isEnabled())
    {//On diminue les poids seulement si la fenêtre était fermée avant
	m_poidsHumidite -= 1;
	m_poidsTemperature -= 1;
    }

    //On ouvre la fenêtre sud
    ui->boutonFenetreSud->setText("Fermer");
    ui->vertFenetreSud->setEnabled(true);
    ui->rougeFenetreSud->setEnabled(false);

    //On lance le timer qui gère les poids
    if(!(m_timerPoids->isActive()))
    {
	m_timerPoids->start(2500);
    }
}
void FenetreControle::fermerFenetreSud()
{
    if(ui->vertFenetreSud->isEnabled())
    {//On augmente les poids seulement si la fenêtre était ouverte avant
	m_poidsHumidite += 1;
	m_poidsTemperature += 1;
    }

    //On ferme la fenêtre sud
    ui->boutonFenetreSud->setText("Ouvrir");
    ui->rougeFenetreSud->setEnabled(true);
    ui->vertFenetreSud->setEnabled(false);

    //On lance le timer qui gère les poids
    if(!(m_timerPoids->isActive()))
    {
	m_timerPoids->start(2500);
    }
}
void FenetreControle::ouvrirPorte()
{
    if(ui->rougePorte->isEnabled())
    {//On diminue les poids seulement si la porte était fermée avant
	m_poidsHumidite -= 1;
	m_poidsTemperature -= 1;
    }

    //On ouvre la porte
    ui->boutonPorte->setText("Fermer");
    ui->vertPorte->setEnabled(true);
    ui->rougePorte->setEnabled(false);

    //On lance le timer qui gère les poids
    if(!(m_timerPoids->isActive()))
    {
	m_timerPoids->start(2500);
    }
}
void FenetreControle::fermerPorte()
{
    if(ui->vertPorte->isEnabled())
    {//On augmente les poids seulement si la porte était ouverte avant
	m_poidsHumidite += 1;
	m_poidsTemperature += 1;
    }

    //On ferme la porte
    ui->boutonPorte->setText("Ouvrir");
    ui->rougePorte->setEnabled(true);
    ui->vertPorte->setEnabled(false);
    //Quand la porte est fermée, la température et l'humidité augmentent
    m_poidsHumidite += 1;
    m_poidsTemperature += 1;

    //On lance le timer qui gère les poids
    if(!(m_timerPoids->isActive()))
    {
	m_timerPoids->start(2500);
    }
}
void FenetreControle::lancerBrumisateur()
{
    if(ui->rougeArrosage->isEnabled())
    {//On augmente l'humidité seulement si le brumi était fermé avant
	m_poidsHumidite += 1;
    }

    //On active le brumisateur
    ui->boutonArrosage->setText("Arrêter");
    ui->vertArrosage->setEnabled(true);
    ui->rougeArrosage->setEnabled(false);
    ui->actionLancerArrosage->setText("Arrêter le brumisateur");

    //On lance le timer qui gère les poids
    if(!(m_timerPoids->isActive()))
    {
	m_timerPoids->start(2500);
    }
}
void FenetreControle::arreterBrumisateur()
{
    if(ui->vertArrosage->isEnabled())
    {//On augmente les poids seulement si la fenêtre était ouverte avant
	m_poidsHumidite -= 1;
    }

    //On désactive le brumisateur
    ui->boutonArrosage->setText("Démarrer");
    ui->rougeArrosage->setEnabled(true);
    ui->vertArrosage->setEnabled(false);
    ui->actionLancerArrosage->setText("Lancer le brumisateur");

    //On lance le timer qui gère les poids
    if(!(m_timerPoids->isActive()))
    {
	m_timerPoids->start(2500);
    }
}


//SIGNAUX

//SLOTS
//Les slots des sliders
void FenetreControle::on_sliderHumidite_valueChanged(int valeur)
{
    /*if(!(m_timerHumidite->isActive()))
    {
	m_timerHumidite->start(2000);
    }*/
    ui->progressBarHumidite->setValue(ui->sliderHumidite->value());
    ui->lcdHumidite->display(ui->sliderHumidite->value());

    arreterBrumisateur();

    m_poidsHumidite = 0;
    m_poidsTemperature = 0;
}
void FenetreControle::on_sliderTemperature_valueChanged(int valeur)
{
    /*if(!(m_timerTemperature->isActive()))
    {
	m_timerTemperature->start(4000);
    }*/
    ui->progressBarTemperature->setValue(ui->sliderTemperature->value());
    ui->lcdTemperature->display(ui->sliderTemperature->value());

    fermerFenetreNord();
    fermerFenetreSud();
    fermerPorte();

    m_poidsHumidite = 0;
    m_poidsTemperature = 0;
}

//Les slots des progressbars
void FenetreControle::on_progressBarHumidite_valueChanged(int valeur)
{
    //On vide la mémoire en mettant des espaces à la place
    memoirePartageeLecture->write("        ", false);
    //On écrit la nouvelle valeur dans la mémoire partagée
    memoirePartageeLecture->write("t" + QString::number(ui->progressBarTemperature->value()) + "|h" + QString::number(ui->progressBarHumidite->value()), false);
}
void FenetreControle::on_progressBarTemperature_valueChanged(int valeur)
{
    //On vide la mémoire en mettant des espaces à la place
    memoirePartageeLecture->write("        ", false);
    //On écrit la nouvelle valeur dans la mémoire partagée
    memoirePartageeLecture->write("t" + QString::number(ui->progressBarTemperature->value()) + "|h" + QString::number(ui->progressBarHumidite->value()), false);
}

//La fonction appelée par le timer qui actualise les progress bars
void FenetreControle::gererProgressHumidite()
{
    //GESTION DES SLIDERS
    //Pour l'humidité
    if(ui->sliderHumidite->value() > ui->progressBarHumidite->value())
    {//Si l'humidité demandée est plus grande
	ui->progressBarHumidite->setValue(ui->progressBarHumidite->value() + 1);
	ui->lcdHumidite->display(ui->progressBarHumidite->value());
    }
    else if(ui->sliderHumidite->value() < ui->progressBarHumidite->value())
    {//Si l'humidite demandée est plus petite
	ui->progressBarHumidite->setValue(ui->progressBarHumidite->value() -1);
	ui->lcdHumidite->display(ui->progressBarHumidite->value());
    }
    else
    {//Si on a parfaitement atteind la valeur demandée, on arrête le timer
	m_timerHumidite->stop();
    }

    //Sécurité : on ne peut pas dépasser la valeur minimale ou maximale
    if(ui->lcdHumidite->value() > HUMIDITEMAX)
    {
	ui->progressBarHumidite->setValue(HUMIDITEMAX);
	ui->lcdHumidite->display(HUMIDITEMAX);
    }
    if(ui->lcdHumidite->value() < HUMIDITEMIN)
    {
	ui->progressBarHumidite->setValue(HUMIDITEMIN);
	ui->lcdHumidite->display(HUMIDITEMIN);
    }
}
void FenetreControle::gererProgressTemperature()
{
    //Pour la température
    if(ui->sliderTemperature->value() > ui->progressBarTemperature->value())
    {//Si la température demandée est plus grande
	ui->progressBarTemperature->setValue(ui->progressBarTemperature->value() + 1);
	ui->lcdTemperature->display(ui->progressBarTemperature->value());
    }
    else if(ui->sliderTemperature->value() < ui->progressBarTemperature->value())
    {//Si la température demandée est plus petite
	ui->progressBarTemperature->setValue(ui->progressBarTemperature->value() -1);
	ui->lcdTemperature->display(ui->progressBarTemperature->value());
    }
    else
    {//Si on a parfaitement atteind la valeur demandée, on arrête le timer
	m_timerTemperature->stop();
    }

    //Sécurité : on ne peut pas dépasser la valeur minimale ou maximale
    if(ui->lcdTemperature->value() > TEMPERATUREMAX)
    {
	ui->progressBarTemperature->setValue(TEMPERATUREMAX);
	ui->lcdTemperature->display(TEMPERATUREMAX);
    }
    if(ui->lcdTemperature->value() < TEMPERATUREMIN)
    {
	ui->progressBarTemperature->setValue(TEMPERATUREMIN);
	ui->lcdTemperature->display(TEMPERATUREMIN);
    }
}
void FenetreControle::gererPoids()
{
    //GESTION DES BOUTONS
    ui->progressBarHumidite->setValue(ui->progressBarHumidite->value() + m_poidsHumidite);
    ui->lcdHumidite->display(ui->progressBarHumidite->value() + m_poidsHumidite);
    ui->progressBarTemperature->setValue(ui->progressBarTemperature->value() + m_poidsTemperature);
    ui->lcdTemperature->display(ui->progressBarTemperature->value() + m_poidsTemperature);

    //Sécurité : on ne peut pas dépasser la valeur minimale ou maximale
    if(ui->lcdHumidite->value() > HUMIDITEMAX)
    {
	ui->progressBarHumidite->setValue(HUMIDITEMAX);
	ui->lcdHumidite->display(HUMIDITEMAX);
    }
    if(ui->lcdHumidite->value() < HUMIDITEMIN)
    {
	ui->progressBarHumidite->setValue(HUMIDITEMIN);
	ui->lcdHumidite->display(HUMIDITEMIN);
    }

    //Sécurité : on ne peut pas dépasser la valeur minimale ou maximale
    if(ui->lcdTemperature->value() > TEMPERATUREMAX)
    {
	ui->progressBarTemperature->setValue(TEMPERATUREMAX);
	ui->lcdTemperature->display(TEMPERATUREMAX);
    }
    if(ui->lcdTemperature->value() < TEMPERATUREMIN)
    {
	ui->progressBarTemperature->setValue(TEMPERATUREMIN);
	ui->lcdTemperature->display(TEMPERATUREMIN);
    }
}

//Autoconnects
//Les clicks des boutons sensitifs
void FenetreControle::on_boutonArrosage_clicked()
{
    if(ui->rougeArrosage->isEnabled())
    {
	lancerBrumisateur();
    }
    else
    {
	arreterBrumisateur();
    }
}
void FenetreControle::on_boutonFenetreNord_clicked()
{
    if(ui->rougeFenetreNord->isEnabled())
    {
	ouvrirFenetreNord();
    }
    else
    {
	fermerFenetreNord();
    }
}
void FenetreControle::on_boutonFenetreSud_clicked()
{
    if(ui->rougeFenetreSud->isEnabled())
    {
	ouvrirFenetreSud();
    }
    else
    {
	fermerFenetreSud();
    }
}
void FenetreControle::on_boutonPorte_clicked()
{
    if(ui->rougePorte->isEnabled())
    {
	ouvrirPorte();
    }
    else
    {
	fermerPorte();
    }
}
void FenetreControle::on_actionLancerArrosage_triggered()
{
    on_boutonArrosage_clicked();
}


//Autres fonctions
void FenetreControle::checkerBoutonsContextuels()
{
    //Dans cette fonctions, on ne déclanche aucune action, on vérifie juste que les labels correspondent bien aux couleurs
    //Le bouton du brumisateur
    if(ui->rougeArrosage->isEnabled())
    {
	ui->boutonArrosage->setText("Démarrer");
        ui->vertArrosage->setEnabled(false);
	ui->actionLancerArrosage->setText("Lancer le brumisateur");
    }
    else
    {
	ui->boutonArrosage->setText("Arrêter");
        ui->rougeArrosage->setEnabled(false);
	ui->actionLancerArrosage->setText("Arrêter le brumisateur");
    }
    //Le bouton de la fenêtre nord
    if(ui->rougeFenetreNord->isEnabled())
    {
	ui->boutonFenetreNord->setText("Ouvrir");
	ui->vertFenetreNord->setDisabled(true);
    }
    else
    {
	ui->boutonFenetreNord->setText("Femer");
	ui->vertFenetreNord->setDisabled(false);
    }
    //Le bouton de la fenêtre sud
    if(ui->rougeFenetreSud->isEnabled())
    {
	ui->boutonFenetreSud->setText("Ouvrir");
	ui->vertFenetreSud->setDisabled(true);
    }
    else
    {
	ui->boutonFenetreSud->setText("Femer");
	ui->vertFenetreSud->setDisabled(false);
    }
    //Le bouton de la porte
    if(ui->rougePorte->isEnabled())
    {
	ui->boutonPorte->setText("Ouvrir");
	ui->vertPorte->setDisabled(true);
    }
    else
    {
	ui->boutonPorte->setText("Fermer");
	ui->vertPorte->setDisabled(false);
    }
}

void FenetreControle::checkerMemoirePartagee()
{
    //On réinitialise les variables
    QString ceQuiAEteRecupere = "";
    QString instruction = "";

    //On lit la mémoire partagée
    ceQuiAEteRecupere = memoirePartageeEcriture->read();
    //Si la chaine n'est pas vide (commençant par un espace)
    if(ceQuiAEteRecupere.at(0) != QString(" ").at(0))
    {
	//On parcourt la chaine et on récupère les instructions une par une
	for(int i = 0; i < ceQuiAEteRecupere.length(); i++)
	{
	    //Si on rencontre un pipe, l'instruction a été récupérée, donc on l'éxécute et on continue
	    if((ceQuiAEteRecupere.at(i) == QString("|").at(0)))
	    {
		//Instructions concernant la fenêtre nord
		if(instruction == "ofn")
		{
		    ouvrirFenetreNord();
		    instruction = "";
		}
		if(instruction == "ffn")
		{
		    fermerFenetreNord();
		    instruction = "";
		}

		//Instructions concernant la fenêtre sud
		if(instruction == "ofs")
		{
		    ouvrirFenetreSud();
		    instruction = "";
		}
		if(instruction == "ffs")
		{
		    fermerFenetreSud();
		    instruction = "";
		}

		//Instructions concernant la porte
		if(instruction == "op")
		{
		    ouvrirPorte();
		    instruction = "";
		}
		if(instruction == "fp")
		{
		    fermerPorte();
		    instruction = "";
		}

		//Instructions concernant le brumisateur
		if(instruction == "ob")
		{
		    lancerBrumisateur();
		    instruction = "";
		}
		if(instruction == "fb")
		{
		    arreterBrumisateur();
		    instruction = "";
		}
	    }
	    else
	    {//Sinon, on continue à récupérer l'instruction
		instruction.append(ceQuiAEteRecupere.at(i));
	    }
	}
    }
}
