#ifndef FENETRECONTROLE_H
#define FENETRECONTROLE_H

#include <QtGui/QMainWindow>
#include <QTimer>
#include "sharedmem.h"

namespace Ui
{
    class FenetreControle;
}

class FenetreControle : public QMainWindow
{
    Q_OBJECT

    public:
        FenetreControle(QWidget *parent = 0);
        ~FenetreControle();
	void checkerBoutonsContextuels();
	//Fonctions de contrôle des fenêtres, etc
	void ouvrirFenetreNord();
	void fermerFenetreNord();
	void ouvrirFenetreSud();
	void fermerFenetreSud();
	void ouvrirPorte();
	void fermerPorte();
	void lancerBrumisateur();
	void arreterBrumisateur();



    public slots:
	//Les autoconnects
	void on_boutonArrosage_clicked();
	void on_boutonFenetreNord_clicked();
	void on_boutonFenetreSud_clicked();
	void on_boutonPorte_clicked();
	void on_actionLancerArrosage_triggered();
	//Les slots des sliders
	void on_sliderHumidite_valueChanged(int valeur);
	void on_sliderTemperature_valueChanged(int valeur);
	//Les slots des progressbars
	void on_progressBarHumidite_valueChanged(int valeur);
	void on_progressBarTemperature_valueChanged(int valeur);
	//Les fonctions appelée par le timer pour mettre à jour les progress bars
	void gererProgressHumidite();
	void gererProgressTemperature();
	void gererPoids();
	//La fonction qui vérifie la mémoire partagée
	void checkerMemoirePartagee();


    private:
        Ui::FenetreControle *ui;
	SharedMem *memoirePartageeEcriture;
	SharedMem *memoirePartageeLecture;
	int m_poidsHumidite;
	int m_poidsTemperature;
	QTimer *m_timerHumidite;
	QTimer *m_timerTemperature;
	QTimer *m_timerPoids;
	QTimer *m_timerMemoirePartagee;
};

#endif // FENETRECONTROLE_H
