#include "sharedmem.h"

SharedMem::SharedMem(QString key, int size)
{
    //On crée et/ou attache memory a la mémoire partagee
    memory = new QSharedMemory(key, this);
    if(!memory->create(size)){
        memory->attach(QSharedMemory::ReadWrite);
    }
}

SharedMem::~SharedMem(){
    //~QObject();

    //On detache la memoire, si c'est la derniere instance a utiliser
    //Cette zone memoire, alors elle est detruite
    memory->detach();
}

QString SharedMem::read(){
    //Lecture de la memoire partagée
    QString text;
    memory->lock();
    text = (char*) memory->data();
    memory->unlock();

    //Vidage de la zone de memoire partagée en remplacant le texte par une chaine vide
    QString empty;
    for(unsigned int i = 0; i < 16; i++){
	empty += (QString) " ";
    };

    write(empty, false);
    return text;
}

int SharedMem::write(QString msg, bool ignore){
    //On transforme le message en une suite d'octets codés en ASCII
    QByteArray ba = msg.toAscii();
    //On empêche les accès à la mémoire pour éviter les conflits
    memory->lock();

    //On récupère le pointeur de la zone mémoire partagée
    //Et on le convertit en QString
    char *to = (char*)memory->data();
    QString memoryString = (QString) *to;

    if(ignore){
	//Si la zone de mémoire est vide
	if(memoryString.at(0) == QString(" ").at(0)){
	    const char *from = ba.data();
	    //On met le message dans la zone mémoire partagée
	    memcpy(to, from, ba.size());
	}
    } else {
	const char *from = ba.data();
	//On met le message dans la zone mémoire partagée
	memcpy(to, from, ba.size());
    }
    //On dévérouille la mémoire pour qu'un autre utilisateur puisse travailler dessus
    memory->unlock();
    return 1;
}


/*
void SharedMem::clear(){
    memclr(memory->data(), memory->size());
}*/
