/* Programme de gestion d'un turbidimètre/colirimètre
 * Réalisé par Renan Waroux, renan.waroux@gmail.com
 * Pour Objectif Sciences International
 * Le 10/08/2011
 */

// Les constantes, faites pour indiquer les numéros de pins 
const int buttonPin = 2;     // Le pin du bouton
const int ledPinG =  8;      // Le pin de la led verte
const int ledPinR =  9;      // Le pin de la led rouge
const int laserPin = 4;      // Pin digital du laser
int cmpt,photo = 0;

//Pour les variables anti rebonds
long lastDebounceTime = 0;  // variable pour mémoriser le temps écoulé depuis le dernier changement de la LED
long debounceDelay = 50;    //intervalle anti-rebond

//Variables
int buttonState = 0;         // Variable utilisée pour lire l'état du bouton poussoir

void setup() {
  // On initialise les pins des leds et du laser comme sortie
  pinMode(ledPinG, OUTPUT);  
  pinMode(ledPinR, OUTPUT);  
  pinMode(laserPin, OUTPUT);
  // On initialise le pin du bouton poussoir comme entrée
  pinMode(buttonPin, INPUT); 
  // Démarrage de la communication série
  Serial.begin(9600); 
  
  // On attache l'interruption externe n°0 à la fonction changeLedColor
  attachInterrupt(0, changeLedColor, CHANGE); 
}

void loop(){
 
  //Lire la tension à l'entrée analogique 0
  photo = analogRead(0);

  //Affichage des données
  Serial.print("Capteur 1: ");
  Serial.println(photo,DEC);
  
  delay(500);
  
  // Lire la tension à l'entrée analogique 1
  photo = analogRead(1);
  Serial.print("Capteur 2: ");
  Serial.println(photo,DEC);
  
  delay(1500);

}

void changeLedColor()
{ 
 // Lit l'état du bouton poussoir et le stocke dans une variable locale type int
 buttonState = digitalRead(buttonPin); 
  
 if ( buttonState == HIGH )
  { 
    //On allume la led verte
    if(cmpt%3 == 0)
    {
     digitalWrite(ledPinG, HIGH);  
     digitalWrite(ledPinR, LOW); 
     analogWrite(laserPin, 0);//on met du 0V en sortie 
     
     Serial.println("Led allumee en vert");
    }
    else if(cmpt%3 == 1)//On allume la led rouge
    {  
     digitalWrite(ledPinR, HIGH);
     digitalWrite(ledPinG, LOW);
     analogWrite(laserPin, 0);//on met du 0V en sortie
          
     Serial.println("Led allumee en rouge");
    }
    else if(cmpt%3 == 2)//On allume le laser
    {
      digitalWrite(ledPinR, LOW);
      digitalWrite(ledPinG, LOW);
      analogWrite(laserPin, 254);//on met du 3V en sortie
      
      Serial.println("Laser allumee");
    }
    
  }
  else 
  {
    //On incrémente le compteur
    if( cmpt < 1000) cmpt++;
    else cmpt = 0;
  } 
}
